


; Lap Counter

; CPU configuration
	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc


;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_OFF & _CCP1_RB3  & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_OFF & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF


; Define variables at memory locations

EEPROM1		equ	H'00'	; non-volatile storage for display on period
EEPROM2		equ	H'01'	; non-volatile storage for counter speed
EEPROM3		equ	H'02'	; storage for dimming value

; RAM
; bank 0 

COUNTER		equ	H'20'	; count value
OFF			equ	H'21'	; off flag for display on or off
STORE1			equ	H'22'	; delay store
STORE2			equ	H'23'	; delay store
STORE3			equ	H'24'	; delay store	
CONVERSION	equ	H'25'	; delay before A/D conversion 
BIN_0			equ	H'26'	; 8-bit binary value
BCD_0			equ	H'27'	; MS BCD value
BCD_1			equ	H'28'	; LS binary coded decimal value
TEMP			equ	H'29'	; data storage 
CNT_8			equ	H'2A'	; counter in BCD routine
DISP1			equ	H'2B'	; display 1 
DISP2			equ	H'2C'	; display 2 
PORTB_STO		equ	H'2D'	; store PORTB
PORTA_STO		equ	H'2E'	; store PORTA
INTERRUPT_NO	equ	H'2F'	; number of interrupts
MPX_CYCLE	equ	H'30'	; multiplex cycle counter
ON_PERIOD		equ	H'31'	; display on period (powered on time)
SPEED			equ	H'32'	; counter update speed
RATE			equ	H'33'	; timer for counter update. decreased in interrupt
RATE_TIMES	equ	H'34'	; increases counter rate period 
RATE_VALUE	equ	H'35'	; change rate for counter. Value is used for RATE_TIMES
DIMMING		equ	H'36'	; dimming value 
DIM_RATE			equ	H'37'	; timer for dimming update. decreased in interrupt
DIM_RATE_TIMES	equ	H'38'	; increases dimming rate period 
DIM_RATE_VALUE	equ	H'39'	; change rate for counter. Value is used for DIM_RATE_TIMES


; all banks ram
W_TMP			equ	H'70'	; temporary store for w in interrupt
STATUS_TMP	equ	H'71'	; temporary store of status in interrupt 
COMP			equ	H'72'	; comparator output level

	ORG     H'2100'

	DE	D'125', D'250', D'0'	; 5s display show, 5s counter rate, no dimming

	
; define reset and interrupt vector start addresses

	org		0			; start at address 0000h
	goto	MAIN		; normal service routines from Reset vector
	org    	 4			; interrupt vector 0004h, start interrupt routine here
	goto	INTERRUPT

;_________________________________________

; lookup tables for 7-segment displays. Uses PORTA and PORTB so separate lookups. Also DISP1 and DISP2 do not  have the same segments connected to the RA,RB outputs 

; settings for display 1 and 2 for PORTA
; RA0,RA6, RA7
DISP1_PORTA
; on with RA4 high
; (d,c,e) segments (RA0,RA6,RA7)
	addwf		PCL,f		; 0-9
;				   ec            d	
	retlw		B'11000001'	; 0 -d,c,e
	retlw		B'01000000'	; 1 - c			
	retlw		B'10000001'	; 2 -d,e
	retlw		B'01000001'	; 3 -d,c
	retlw		B'01000000'	; 4 -c
	retlw		B'01000001'	; 5 -c,d
	retlw		B'11000001'	; 6 -d,c,e
	retlw		B'01000000'	; 7 -c
	retlw		B'11000001'	; 8 -d,c,e
	retlw		B'01000001'	; 9 -d,c

DISP2_PORTA
; on with RA3 high
; (d,e,c) segments (RA0,RA7,RA6)
	addwf		PCL,f		; 0-9
;				   ce            d	
	retlw		B'00000000'	; 0 -all off for leading zero suppression (d,c,e)
	retlw		B'10000000'	; 1 -c			
	retlw		B'01000001'	; 2 -d,e
	retlw		B'10000001'	; 3 -d,c
	retlw		B'10000000'	; 4 -c
	retlw		B'10000001'	; 5 -c,d
	retlw		B'11000001'	; 6 -d,c,e
	retlw		B'10000000'	; 7 -c
	retlw		B'11000001'	; 8 -d,c,e
	retlw		B'10000001'	; 9 -d,c

; settings for display 1 and 2 for PORTB
DISP1_PORTB
; on with RA4 high
; b,a,f,g  (RB7,6,5,4)
	addwf		PCL,f		; 0-9
;				   bafg
	retlw		B'11100000'	; 0 -a,b,f 
	retlw		B'10000000'	; 1 -b
	retlw		B'11010000'	; 2 -a,b,g
	retlw		B'11010000'	; 3 -a,b,g 
	retlw		B'10110000'	; 4 -f,g,b
	retlw		B'01110000'	; 5 -g,f,a
	retlw		B'01110000'	; 6 -g,f,a
	retlw		B'11000000'	; 7 -ab
	retlw		B'11110000'	; 8 -gfab
	retlw		B'11110000'	; 9 -gfab
	
DISP2_PORTB
; on with RA3 high
; g,f,a,b  (RB7,6,5,4)
	addwf		PCL,f		; 0-9
;				   gfab
	retlw		B'00000000'	; 0 - all off due to leading zero suppression (a,b,f )
	retlw		B'00010000'	; 1 -b
	retlw		B'10110000'	; 2 -a,b,g
	retlw		B'10110000'	; 3 -a,b,g 
	retlw		B'11010000'	; 4 -f,g,b
	retlw		B'11100000'	; 5 -g,f,a
	retlw		B'11100000'	; 6 -g,f,a
	retlw		B'00110000'	; 7 -ab
	retlw		B'11110000'	; 8 -gfab
	retlw		B'11110000'	; 9 -gfab
	

; ************************************************************************************	
; start interrupt by saving w and status registers before altered by interrupt routine

INTERRUPT
	
	movwf	W_TMP			; w to w_tmp storage
	swapf	STATUS,w		; status to w
	movwf	STATUS_TMP	; status in status_tmp  
	bcf		STATUS,RP0	; select memory bank 0
	bcf		STATUS,RP1

	bcf		INTCON,TMR0IF	; clear TMR0 interrupt flag

	incf		INTERRUPT_NO,f
	
; if DIMMING is 0 no dimming
	movf	DIMMING,W
	btfsc	STATUS,Z
	goto	INC_4

; if dimming is 1 then display off once in 4
	movf	DIMMING,w
	xorlw	D'1'
	btfss	STATUS,Z
	goto	DIM2

; if INTERRUPT_NO is 1 and DIMMING is 1 add display off
	movf	INTERRUPT_NO,w
	xorlw	D'3'
	btfss	STATUS,Z	
	goto	INC_4
	movlw	B'00000000'
	movwf	PORTA			; segments off
	movwf	PORTB
	goto	INC_4

DIM2 ; if dimming is 2 display off twice in 4
	movf	DIMMING,w
	xorlw	D'2'
	btfss	STATUS,Z
	goto	DIM3

; if INTERRUPT_NO is 1 and DIMMING is 2 add display off
	movf	INTERRUPT_NO,w
	xorlw	D'2'
	btfss	STATUS,Z	
	goto	INC_4
	movlw	B'00000000'
	movwf	PORTA			; segments off
	movwf	PORTB
	goto	INC_4

DIM3
; if dimming is 3 display off 3x in 4
	movf	DIMMING,w
	xorlw	D'3'
	btfss	STATUS,Z
	goto	INC_4

; if INTERRUPT_NO is 1 and DIMMING is 3 add display off
	movf	INTERRUPT_NO,w
	xorlw	D'1'
	btfss	STATUS,Z	
	goto	INC_4
	movlw	B'00000000'
	movwf	PORTA			; segments off
	movwf	PORTB

; increase number up to 4
INC_4
	movf	INTERRUPT_NO,w
	sublw	D'03'
	btfsc	STATUS,C
	goto	EOI_END		; end of interrupt
	clrf		INTERRUPT_NO

;check if display has been selected to stay on. 
; ie when ON_PERIOD	; display on period (powered on time) is >250
	movlw	D'251'
	subwf	ON_PERIOD,w
	btfsc	STATUS,C
	goto	MPLX
OFF_DISP ; is display off?
	btfss	OFF,0			; if set then display is off
	goto	MPLX
; clear displays		
	movlw	B'00000000'
	movwf	PORTA			; segments off
	movwf	PORTB
	goto	EOI_END

; ---------------------------------------------------------------------------
MPLX
; Multiplex displays

	incf		MPX_CYCLE,f	; multiplex cycle counter

; decrease RATE for counter
	decfsz	RATE_TIMES,f	; decrease rate period 
	goto	MPX_GO
	movf	RATE,w
	btfss	STATUS,Z		; if zero leave at 0
	decf	RATE,f
; set counter
	movf	RATE_VALUE,w	; reset rate 
	movwf	RATE_TIMES	;  counter increases the rate period

; decrease rates for dimming
; decrease RATE for counter
	decfsz	DIM_RATE_TIMES,f	; decrease rate period 
	goto	MPX_GO
 	movf	DIM_RATE,w
	btfss	STATUS,Z		; if zero leave at 0
	decf	DIM_RATE,f
; set counter
	movf	DIM_RATE_VALUE,w	; reset rate 
	movwf	DIM_RATE_TIMES	;  counter increases the rate period

MPX_GO

; clear display
	movlw	B'00000000'
	movwf	PORTA			; segments off
	movwf	PORTB
DIGIT
	btfss	MPX_CYCLE,0	; bit 0 selects Disp1or 2
	goto	SHOW_DISP1

SHOW_DISP2
; leading zero blanking is automatic if 0 due to lookup table

; load display	
	movf	DISP2,w
	call		DISP2_PORTA	; get values for driving 7-SEG via portA
	movwf	PORTA_STO
	movf	DISP2,w
	call		DISP2_PORTB	; get values for driving 7-SEG via portB
	movwf	PORTB_STO

; select digit2	
	bsf		PORTA_STO,4	; common anode drive
	movf	PORTB_STO,w
	movwf	PORTB
	movf	PORTA_STO,w
	movwf	PORTA
	goto	EOI_END

SHOW_DISP1

; load display
	movf	DISP1,w
	call		DISP1_PORTA	; get values for driving 7-SEG via portA
	movwf	PORTA_STO	
	movf	DISP1,w
	call		DISP1_PORTB	; get values for driving 7-SEG via portB
	movwf	PORTB_STO

; select digit1	
	bsf		PORTA_STO,3	; common anode drive
	movf	PORTB_STO,w
	movwf	PORTB
	movf	PORTA_STO,w
	movwf	PORTA

; end of interrupt reclaim w and status 
EOI_END

	swapf	STATUS_TMP,w	; status temp storage to w
	movwf	STATUS			; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   	W_TMP,w		; swap bits and into w register
	retfie					; return from interrupt


;********************************************************************************************** 
   	
; Set ports A & B

MAIN

	clrf		PORTA
	clrf		PORTB

; set inputs/outputs
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00000101'		; comparator on (output C2OUT at bit 7)
	movwf	CMCON
	movlw	B'00000000'		; 
	movwf	OPTION_REG	; TMR0 prescaler , PORTB pullups on

; initially set RB2 and RB3 as high outputs to force a high if view and/or count switches are open

	movlw	B'00000011'		; Inputs/outputs
	movwf	TRISB			; port B data direction register
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'00001100'		; high  RB2,3
	movwf	PORTB
	nop
	nop
	nop
	nop

; Port B (RB2,3 now set for inputs)
	bsf		STATUS,RP0	; select memory bank 1
	movlw	B'00001111'		; Inputs/outputs
	movwf	TRISB			; port B data direction register
; port A	
	movlw   B'00100110'		; Inputs/ outputs 
	movwf   TRISA			; port A data direction register

	movlw	B'01111000'		; for 8MHz
	movwf	OSCCON		; osc

; analog inputs, A/D

	movlw	B'00000110'		; AN1,2, analog inputs (for comparator)
	movwf	ANSEL

	movlw	B'01000000'		; left justified, references 0V and 5V
	movwf	ADCON1
	bcf		STATUS,RP0	; select memory bank 0
	movlw	B'01001000' 		; Fosc, channel 1 etc
	movwf	ADCON0
	bsf		ADCON0,ADON	; A/D on

; initialise
	clrf		RATE			; counter update rate
	clrf		COUNTER		; count value
	clrf		OFF			; off flag for display on or off
	clrf		DISP1			; display 1 
	clrf		DISP2			; display 2 
	clrf		MPX_CYCLE	; multiplex cycle counter
	clrf		INTERRUPT_NO	; interrupt number

	movlw	D'20'
	movwf	RATE_VALUE	; change rate for counter. Value is used for RATE_TIMES set after an increase in count and then used in interrupt
	movlw	D'1'
	movwf	RATE_TIMES	; decrease rate period

	movlw	D'5'
	movwf	DIM_RATE_VALUE	; change rate for dimming. Value is used for DIM_RATE_TIMES set after an increase in count and then used in interrupt
	movlw	D'1'
	movwf	DIM_RATE_TIMES	; decrease rate period
 
; get EEPROM values
	movlw	EEPROM1		; non-volatile storage for display on period	
	call		EEREAD
	movwf	ON_PERIOD		; display on period (Lit time)

	movlw	EEPROM2		; non-volatile storage for counter speed
	call		EEREAD
	movwf	SPEED			; counter update speed

	movlw	EEPROM3		; non-volatile storage for dimming
	call		EEREAD
	movwf	DIMMING		; dimming

; check if View (RB2) is low (pressed at power up)
CK_VIEW
; if not then check S4

	btfsc	PORTB,2	
	goto	CK_S4	
; view switch pressed
; switch needs to be  closed for 5s
	call		DELAY
	btfsc	PORTB,2	; still pressed
	goto	CK_S4

; write V (actually U) on display2
	movlw	B'10100000'	; f,b
	movwf	PORTB
	movlw	B'11001001'	; d,c,e
	movwf	PORTA	
CK_VIEW1
	call		ACQUIRE_AD
	movf	ADRESH,w
	movwf	ON_PERIOD	
 	btfss	PORTB,2		; continue setting via VR1 while switch is closed
	goto	CK_VIEW1
; set the view period based on VR1
; write to EEPROM
	movlw	EEPROM1		; non-volatile storage for display on period	
	call		EEREAD		; sets EEADR (address)
	movf	ON_PERIOD,w
	call		EEWRITE
	goto	MINIMUM	

; check if Switch S4 pressed at power up (external count switch)
CK_S4
; if so then set the counter rate based on VR1
	btfsc	PORTB,3	
	goto	MINIMUM

; switch S4 needs to be  closed for 5s
	call		DELAY
	btfsc	PORTB,3	
	goto	MINIMUM
; write C on display2
	movlw	B'01100000'	; f,a
	movwf	PORTB
	movlw	B'10001001'	; d,e
	movwf	PORTA	
CK_S4_1
	call		ACQUIRE_AD
	movf	ADRESH,w

; non-linearise for better control at low settings
; if 63 or less divide by 8
	movlw	D'63'
	subwf	ADRESH,w	
	btfss	STATUS,C
	goto	DIV8

; if less than 127. Take 63  from  value  and divide by 4 and add 8
	movlw	D'127'
	subwf	ADRESH,w	
	btfss	STATUS,C
	goto	DIV4
; if less than 191, Take 127 from value and divide by 2 and add 16 +8
	movlw	D'191'
	subwf	ADRESH,w	
	btfss	STATUS,C
	goto	DIV2
; otherwise take 191  from value and x 2 add 56
	movlw	D'191'
	subwf	ADRESH,f
	bcf		STATUS,C
	rlf		ADRESH,f
	movlw	D'56'
	addwf	ADRESH,w	
	goto	TO_SPEED

DIV2
;/2
	movlw	D'127'
	subwf	ADRESH,f
	bcf		STATUS,C
	rrf		ADRESH,f
	movlw	D'24'
	addwf	ADRESH,w	
	goto	TO_SPEED

DIV4
	movlw	D'63'
	subwf	ADRESH,f
;/2
	bcf		STATUS,C
	rrf		ADRESH,f	
;/4
	bcf		STATUS,C
	rrf		ADRESH,f
	movlw	D'8'
	addwf	ADRESH,w	
	goto	TO_SPEED

DIV8
;/2
	bcf		STATUS,C
	rrf		ADRESH,f	
;/4
	bcf		STATUS,C
	rrf		ADRESH,f	
;/8
	bcf		STATUS,C
	rrf		ADRESH,w	

 ; value to SPEED
TO_SPEED
	movwf	SPEED
	btfss	PORTB,3		; continue setting via VR1 while switch is closed
	goto	CK_S4_1

; write to EEPROM
	movlw	EEPROM2		; non-volatile storage for counter speed	
	call		EEREAD		; sets EEADR (address)
	movf	SPEED,w
	call		EEWRITE
SW_OP
; wait for switches open
	btfss	PORTB,3
	goto	SW_OP
	btfss	PORTB,2
	goto	SW_OP
; delay
	call		DELAY_DISP
; display off
	clrf		PORTA
	clrf		PORTB

MINIMUM
; minimum values for SPEED (counter rate) &  display ON_PERIOD 
SPEED_MIN
	movlw	D'3'
	subwf	SPEED,w
	btfsc	STATUS,C	; if negative set at 3 for minimum value
	goto 	ON_PERIOD_MIN
	movlw	D'3'
	movwf	SPEED
ON_PERIOD_MIN
	movlw	D'5'
	subwf	ON_PERIOD,w
	btfsc	STATUS,C	; if negative set at 5 for minimum value
	goto 	INTERRUPT_ENABLE
	movlw	D'5'
	movwf	ON_PERIOD

; interrupt enable 
INTERRUPT_ENABLE
	bcf		INTCON,TMR0IF	; clear TMR0 interrupt flag
	bsf		INTCON,TMR0IE	; set interrupt enable for TMR0 
	bsf		INTCON,GIE		; set global interrupt enable for above


DISPLAY_RUN_ON
; run display for set period
	movf	ON_PERIOD,w	; display on period
	movwf	STORE2

DISP_RUN_PERIOD
	call		DELAY_DISP	; delay

; check within on period for comparator or S4 or View switches. View restarts  view period, and S4/comparator allows further updating at speed rate

	btfsc	PORTB,2			; View switch?
	goto	INPUTS

; if DIM_RATE is zero, set dimmer off
	movf	DIM_RATE,w
	btfss	STATUS,Z
	goto	DISPLAY_RUN_ON	; View pressed restarts  view period
; dimmer
; adjust dimming

INC_DIM 
;check switch
	btfsc	PORTB,2			; View switch when open store value
	goto	STO_DIM
	incf		DIMMING,f

	movf	DIMMING,w
	sublw	D'03'
	btfss	STATUS,C
	clrf		DIMMING	

	movlw	D'20'
	movwf	STORE3
	call		DELAY1
	goto	INC_DIM

STO_DIM
	movlw	EEPROM3
	call		EEREAD
	movf	DIMMING,w
	call		EEWRITE1	; store in EEPROM

; set dimmer rate timer 
	movf	DIM_RATE_VALUE,w
	movwf	DIM_RATE_TIMES	;  counter increases the rate period
	movlw	D'15'
	movwf	DIM_RATE			; decreased in interrupt
	goto	DISPLAY_RUN_ON	; View pressed restarts  view period

INPUTS
; set dimmer rate timer 
	movf	DIM_RATE_VALUE,w
	movwf	DIM_RATE_TIMES	;  counter increases the rate period
	movlw	D'15'
	movwf	DIM_RATE			; decreased in interrupt

; counter inputs RB3 and  pressure switch via comparator
; if RB3 low then increase counter (see JP1,JP2 for odd/even and single or double step) 
	btfss	PORTB,3
	goto	COUNT

; read  comparator level
	bsf		STATUS,RP0	; select memory bank 1
	clrf		COMP			; cleared 
	btfsc	CMCON,7		; comparator output
	bsf		COMP,7			; stays clear unless bit 7 CMCON is set
	bcf		STATUS,RP0	; select memory bank 0

; check comparator output	
	btfsc	COMP,7
	goto	COUNT

; continue with delay

	decfsz	STORE2,f
	goto	DISP_RUN_PERIOD
	bsf		OFF,0			; set off flag so display is off

DISPLAY_RUN_OFF	; when display is off 

; VIEW switch pressed?
; If RB2 low then View 	(clear OFF flag)
	btfss	PORTB,2
	goto	VIEW

; counter inputs RB3 and  pressure switch via comparator
; if RB3 low then increase counter (see JP1,JP2 for odd/even and single or double step) 
	btfss	PORTB,3
	goto	COUNT

; read  comparator level
	bsf		STATUS,RP0	; select memory bank 1
	clrf		COMP			; cleared unless bit 7 is set
	btfsc	CMCON,7		; comparator output
	bsf		COMP,7
	bcf		STATUS,RP0	; select memory bank 0

; check comparator output	
	btfsc	COMP,7
	goto	COUNT
	goto	DISPLAY_RUN_OFF	; when display is off 

VIEW
	clrf		OFF			; display off flag
	goto	DISPLAY_RUN_ON

COUNT
; only change if RATE counter is zero
	movf	RATE,w
	btfss	STATUS,Z
	goto	VIEW
; increase counter based on JP1,JP2 for odd/even and single or double step) 
; must have a delay to prevent multiple counts	

; JP1 (RB1) low then odd count up (0,1,3,5,7,9,11 etc)
; JP1 high is evens  (0,2,4,6,8,10 etc)
; JP2 (RB0) low then count by 2	(0,2,4,6,8)
; JP2 high  then count by 1 (JP1 ignored)	 

; JP2
	btfsc	PORTB,0	; if high count by 1's
	goto	ONE_UP
; count by 2's
; check JP1
	btfss	PORTB,1
	goto	ODD_UP
TWO_UP
;+1
	incf		COUNTER,f
	movlw	D'99'
	subwf	COUNTER,w
	btfsc	STATUS,C		; if plus then >99 so  set count at 0
	clrf		COUNTER		; cleared
; +1
ONE_UP
	incf		COUNTER,f
	movlw	D'99'
	subwf	COUNTER,w
	btfsc	STATUS,C		; if plus then >99 so  set count at 0
	clrf		COUNTER		; cleared
	call		CONV			; convert binary COUNTER to display digits
; set counter rate timer to limit counter update speed
	movf	RATE_VALUE,w
	movwf	RATE_TIMES	;  counter increases the rate period
	movf	SPEED,w

	movwf	RATE			; decreased in interrupt
	goto	VIEW			; view display

ODD_UP
; if counter=0 add 1 otherwise add 2
	movf	COUNTER,w
	btfsc	STATUS,Z
	goto	ONE_UP
	goto	TWO_UP
			
; **********************************************************
; general subroutines

DELAY_DISP; display delay
	movlw	D'100'
	movwf	STORE3
DELAY_DSP1
	movlw	D'255'	;
	movwf	STORE1
LOOP_D2
	decfsz	STORE1,f
	goto	LOOP_D2
	decfsz	STORE3,f
	goto	DELAY_DSP1
	return


DELAY
	movlw	D'50'
	movwf	STORE3
DELAY1
	movlw	D'255'	;
	movwf	STORE1
LOOP2
	movlw	D'255'
	movwf	STORE2
LOOP1
	decfsz	STORE2,f
	goto	LOOP1
	decfsz	STORE1,f
	goto	LOOP2
	decfsz	STORE3,f
	goto	DELAY1
	return

; _____________________________________________
; Display conversions converting binary counter value to BCD and display position

; convert counter to BCD for display
CONV
	movf	COUNTER,w
	movwf	BIN_0
	call		BCD			; convert to BCD
; BCD_0 and BCD_1 have unpacked decimal values
	movf	BCD_1,w		;  
	andlw	H'0F'			; get ls 4-bits
	movwf	DISP1
	swapf	BCD_1,w		; 
	andlw	H'0F'			; get ms 4-bits
	movwf	DISP2
	return

; Subroutine to convert from 8-bit binary to 2-digit BCD (packed)
; Binary value is in BIN_0  
; Result in BCD is in BCD_0 & BCD_1.  
; BCD_0 is MSB, BCD_1 is LSB

BCD
	bcf		STATUS,C	; clear carry bit
	movlw	D'8'
	movwf	CNT_8		; 8 in count
	clrf		BCD_0
	clrf		BCD_1		; set BCD registers to 0 
LOOPBCD
	rlf		BIN_0,f		; shift left binary registers
	rlf		BCD_1,f		; MSB shift left
	rlf		BCD_0,f		; LSB shift left BCD registers
	decfsz	CNT_8,f		; reduce count value return when 0
	goto	DECADJ	; continue decimal adjust
	return				; completed decimal to BCD operation

; subroutine decimal adjust

DECADJ
	movlw	BCD_1		; BCD LSB address
	movwf	FSR		; pointer for BCD1
	call		ADJBCD	; subroutine to adjust BCD
	movlw	BCD_0		; BCD MS address
	movwf	FSR		; pointer for BCD0
	call		ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD
ADJBCD
	movlw	0x03		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 0-1)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	0x30		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w in temp
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine

; subroutine to wait for A/D conversion

ACQUIRE_AD
; wait for >20us
	movlw	D'80'
	movwf	CONVERSION
LOOP_CONV
	decfsz	CONVERSION,f	; decrease 
	goto	LOOP_CONV	
	bsf		ADCON0,2		; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,2		; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	return
	
; subroutine to read EEPROM memory 

EEREAD
	bcf		STATUS,RP0	; select bank 0
	bsf 		STATUS,RP1	; select memory bank 2
	movwf 	EEADR			; indirect special function register
	bsf 		STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD		; read EEPROM
	bcf 		STATUS,RP0	; select memory bank 2
	movf	EEDATA,w		; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM

EEWRITE	
	bcf 		STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 		STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE		; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'			; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'			; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
;	bsf 		INTCON,GIE		; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE			; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 		STATUS,RP0	; select memory bank 0
	return					; value written 

EEWRITE1	
	bcf 		STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 		STATUS,RP0	; select memory bank 3
WR4	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR4			; not written yet
	bcf		INTCON,GIE		; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'			; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'			; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 		INTCON,GIE		; enable interrupts
WRITE1
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE1			; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 		STATUS,RP0	; select memory bank 0
	return					; value written 

	end


	
